%--------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      Simulate4_Selected.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
% Class:          PSYCH221
% Description:    This file runs the 4 sensor project based on a selected
%                 set of previous results
%--------------------------------------------------------------------------
close all; clear all; clc;
warning('OFF');

SavePlots = true;
numSensors = 4;

% Note: The previous results must be saved in the file 'Results_4.mat'
% mean4 = 3.0481, 60.1514, 3.0419
% Load in all the data that we are choosing from
load Results_4.mat
deltaE_Idx = 2*numSensors + 1;
MTF50_Idx = 2*numSensors + 2;

FindValues = [  3.042 60.2 ;    % Mean
                3.071 60.4;     % Mean
                3.01 60.2;      % Mean
                2.622 171.6;    % Best Freq
                1.062 63];      % Best color
FindIdx = [];
Tol = 0.0001;

% Make a vactor of distances to test
Dist = sqrt(Results4(:,deltaE_Idx).^2 + Results4(:,MTF50_Idx).^2);

for NumIdx = 1:1:size(FindValues,1),
    Val = sqrt(FindValues(NumIdx,1).^2 + FindValues(NumIdx,2).^2);
    Rows = find(abs(Dist - Val) <= Tol);
    FindIdx = [FindIdx ; Rows];
end

FindIdx
Results4(FindIdx,:)

% Save the names of te parameters that we are changing
sensorSettings_Names = {'Width1','Width2','Width3','Width4','Pos1','Pos2','Pos3','Pos4'};
sensorSettings = Results4(FindIdx,1:2*numSensors);
save('SensorData4.mat', 'sensorSettings_Names', 'sensorSettings');

NumRows = size(sensorSettings,1);       % Number of different sensors that we're running
colorMetrics = zeros(NumRows,1);        % Initialize vector to save color metrics            
noiseMetrics = zeros(NumRows,1);        % Initialize vector to save noise metrics
frequencyMetrics = zeros(NumRows,1);    % Initialize vector to save frequency metrics

sensorIndex = 1;
analysisIndex = 1;
save('SavedData4.mat','colorMetrics','noiseMetrics','frequencyMetrics','sensorIndex','analysisIndex');

% Loop through all the sensors
Simulate4_Sub;

% Put the results into a matrix that we can save
%--------------------------------------------------------
ResultNames4 = sensorSettings_Names;
Results4 = sensorSettings;

Results4 = [Results4 colorMetrics frequencyMetrics noiseMetrics]; 
ResultNames4 = {ResultNames4{:},'deltaE','MTF50','yNoise'};

% Display the results
disp(ResultNames4);
disp(Results4);

% Save the final results
save('Results_4_Selected.mat', 'ResultNames4', 'Results4');

% Plot the final results
colors = ['r', 'g', 'b', 'y', 'c', 'm', 'k'];
figure(1);
plot(frequencyMetrics, colorMetrics, 'bo','MarkerFaceColor','b');
xlabel('MTF-50');
ylabel('Average \Delta E');
title('\bfColor Accuracy vs Frequency Accuracy, 4 colors');
grid on;
axis([0 max(1.1*frequencyMetrics) 0 max(1.1*colorMetrics)]);

saveas(gcf, ['./Images/Results_4_Selected.eps'],'epsc2');
saveas(gcf, ['./Images/Results_4_Selected.png']);





